(defun c:lwoffsout (/ ss-offsetpts eqmember butlast ss-pts2area vec2ang gsls-XY->R pipl? ss-assoc ClosestPointTo pt- midpt _2pi _pi2 lwoffsout draw-pl dst lwn ch)

  ;; chlh_jd's variant ;;
  (defun ss-offsetpts
         (l o / f1 f2 p1 p p2 p3 an1 an2 pt lo r out ip is l0 lwn)
    ;;Function ---- offset pointset(L) of a polygon by given distance(o)
    ;;Args:
    ;; l ---- pointset of polygon to offset
    ;; o ---- offset distance , if o>0 give out-offset result
    ;;        if o<0 give inter-offset result
    ;; return new polygons pointset list '(pl1 pl2 ... pli ... pln)
    ;; by GSLS(SS) 2012-6-3
    ;;
    (defun f1 (l / ln l1 p p1 p2 p3 p4 ip ip0 ips g m)
      ;;if crossing-itself ,Break all chains at cross-inters-pts 
      (while l
        (setq p   (car l)
              ln  (cons p ln)
              p1  (cadr l)
              l   (cdr l)
              l1  (cdr l)
              ip  nil
              ip0 nil
              g   nil
        )
        (if (not p1)
          (setq p1 (last ln))
        )
        (while (car l1)
          (setq p2 (car l1)
                p3 (cadr l1)
                l1 (cdr l1)
          )
          (if (not p3)
            (setq p3 (last ln)
                  g T
            )
          )
          (if
            (and (setq p4 (inters p p1 p2 p3))
                 (or (not g) (not (eqmember p4 (list p p1 p2 p3) 1e-5)))
            )
            (setq ip (cons p4 ip))
          )
        )
        (if ips
          (setq
            ip0 (vl-remove-if-not
                  (function (lambda (x)
                              (equal (distance p p1)
                                     (+ (distance p x) (distance x p1))
                                     1e-5
                              )
                            )
                  )
                  ips
                )
          ) ;_(check-pt (list p p1 (car ip0) (cadr ip0)))
        )
        (if (or ip ip0)
          (setq ips (append ip ips)
                ip  (vl-sort (append ip ip0)
                             (function (lambda (e1 e2)
                                         (> (distance p e1) (distance p e2))
                                       )
                             )
                    )
                ln  (append ip ln)
          )
        )
      )
      (if ips
        (progn
          (setq p2 (car ln))
          (while ln
            (setq p  (car ln)
                  p1 (cadr ln)
                  ln (cdr ln)
                  m  (cons p m)
            )
            (setq g T)
            (if ln
              (while (and g ln)
                (if (eqmember p1 ips 1e-5)
                  (setq g nil
                        m (cons p1 m)
                  )
                  (setq m  (cons p1 m)
                        p1 (cadr ln)
                        ln (cdr ln)
                  )
                )
              )
              (setq m (cons p1 m))
            )
            (setq l (cons m l)
                  m nil
            )
          )
          (if (eqmember p2 ips 1e-5)
            (cons (cons p2 (car l)) (cdr l))
            (cons (append (last l) (car l)) (butlast (cdr l)))
          )
        )
        (list (reverse ln))
      )
    );_end dun f1
    ;;kill all loops
    (defun f2 (l / l1 l2 l3 p0 p1 p2 m g v a n)
      (foreach a l
        (if (> (length a) 3)
          (setq l1 (cons a l1))
          (setq l2 (cons a l2))
        )
      )
      (setq l nil)
      (if l1
        (progn
          ;;Link with higher chains
          (while l1
            (setq a  (car l1)
                  l1 (cdr l1)
                  p0 (car a)
                  p1 (last a)
            )
            (if (setq m (vl-remove-if-not
                          (function (lambda (x / p2 p3)
                                      (setq p2 (car x)
                                            p3 (last x)
                                      )
                                      (and (or (equal p0 p2 1e-5)
                                               (equal p0 p3 1e-5)
                                           )
                                           (or (equal p1 p2 1e-5)
                                               (equal p1 p3 1e-5)
                                           )
                                      )
                                    )
                          )
                          l1
                        )
                )
              (progn
                (setq m (car m))
                (if (equal p0 (car m) 1e-5)
                  (setq n (append (cdr (reverse (cdr m))) a))
                  (setq n (append a (butlast (cdr m))))
                )
                (if
                  (vl-some
                    (function (lambda (x)
                                (vl-some (function (lambda (y)
                                                     (> (pipl? y m 1e-5) 0)
                                                   )
                                         )
                                         x
                                )
                              )
                    )
                    l2
                  )
                  (setq l3 (cons a l3))
                  (setq l  (cons n l)
                        l1 (vl-remove m l1)
                  )
                )
              )
              (setq l3 (cons a l3))
            )
          )
          (setq l1 l3
                l3 nil
          )
          ;;Link with other lower chains
          (foreach a l1
            (if (< (ss-pts2area a) 0)
              (setq a (reverse a))
            )
            (setq p1 (cadr a)
                  p2 (car a)
                  p0 (last a)
            )
            (if (setq m
                       (vl-remove-if-not
                         (function
                          (lambda (x / p3 p4)
                             (setq p3 (car x)
                                   p4 (last x)
                             )
                             (or
                               (and (equal p2 p3 1e-5)
                                    (equal p0 p4 1e-5)
                               )
                               (and (equal p0 p3 1e-5)
                                    (equal p2 p4 1e-5)
                               )
                             )
                          )
                         )
                         l2
                       )
                );_through single chain Linking 
              (if (> (length (car m)) 2)
                (setq a (cons (cadar m) a)
                      l (cons a l)
                ) ;_3 points                     
                (setq l (cons a l)) ;_2 points
              )
              (progn
                (setq g T)
                (while g
                  (setq p1 (cadr a)
                        p2 (car a)
                        v  (pt- p1 p2)
                        m  nil
                  )
                  (foreach b l2
                    (if (equal p2 (car b) 1e-5)
                      (setq m (cons b m))
                      (if (equal p2 (last c) 1e-5)
                        (setq m (cons (reverse b) m))
                      )
                    )
                  )
                  (if m
                    (progn
                      (setq
                        m (car (vl-sort
                                 m
                                 (function
                                  (lambda (e1 e2)
                                     (> (vec2ang v (pt- (cadr e1) p2))
                                        (vec2ang v (pt- (cadr e2) p2))
                                     )
                                  )
                                 )
                               )
                          )
                      )
                      (if (equal (last m) p0 1e-5)
                        (progn
                          (setq g nil)
                          (if (> (length m) 2)
                            (setq a (cons (cadr m) a))
                          )
                        )
                        (foreach c (cdr m)
                          (setq a (cons c a))
                        )
                      )
                    )
                    (setq g nil)
                  )
                )
                (setq l (cons a l))
              )
            )
          )
        )
      )
      (setq l2
             (vl-remove-if-not
               (function
                 (lambda (x / p0 p1)
                  (setq p0 (car x)
                        p1 (last x)
                  )
                  (and (vl-some (function (lambda (y)
                                             (and (/= x y)
                                                  (or (equal (car y) p0 1e-5)
                                                      (equal (last y) p0 1e-5)
                                                  )
                                             )
                                          )
                                 )
                                 l2
                        )
                        (vl-some (function (lambda (y)
                                             (and (/= x y)
                                                  (or (equal (car y) p0 1e-5)
                                                      (equal (last y) p0 1e-5)
                                                  )
                                             )
                                          )
                                 )
                                 l2
                        )
                  )
                 )
               )
               l2
             )
      )
      (if (> (length l2) 1)
        (progn
          (setq l1 nil)
          (foreach a l2
            (if (< (length a) 3)
              (setq l3 (cons a l3))
              (setq l1 (cons a l1))
            )
          )
          (setq l2 l3
                l3 nil
          )
          (while l1
            (setq a  (car l1)
                  l1 (cdr l1)
                  p0 (car a)
                  p1 (last a)
            )
            (if (setq m (vl-remove-if-not
                          (function (lambda (x / p2 p3)
                                      (setq p2 (car x)
                                            p3 (last x)
                                      )
                                      (and (or (equal p0 p2 1e-5)
                                               (equal p0 p3 1e-5)
                                           )
                                           (or (equal p1 p2 1e-5)
                                               (equal p1 p3 1e-5)
                                           )
                                      )
                                    )
                          )
                          l1
                        )
                )
              (setq a  (cons (cadar m) a)
                    l1 (vl-remove (car m) l1)
                    l  (cons a l)
              )
              (setq l3 (cons a l3))
            )
          )
          (setq l1 l3)
          (while l1
            (setq a  (car l1)
                  l1 (cdr l1)
                  p0 (car a)
                  p1 (last a)
            )
            (if (setq m (vl-remove-if-not
                          (function (lambda (x / p2 p3)
                                      (setq p2 (car x)
                                            p3 (last x)
                                      )
                                      (and (or (equal p0 p2 1e-5)
                                               (equal p0 p3 1e-5)
                                           )
                                           (or (equal p1 p2 1e-5)
                                               (equal p1 p3 1e-5)
                                           )
                                      )
                                    )
                          )
                          l2
                        )
                )
              (setq l  (cons a l)
                    l2 (vl-remove (car m) l2)
              )
            )
          )
        )
      )
      l
    ) ;_end dun f2 
    ;;Main louting
    ;;by GSLS(SS) 2011.07.05
    (if (< (ss-pts2area l) 0)
      (setq l (reverse l))
    )
    (setq l0 l)
    (if (equal o 0.0 1e-8)
      (list l)
      (progn
        (while l
          (setq p1 (car lo)
                p  (car l)
                p2 (cadr l)
                l  (cdr l)
          )
          ;;first point   
          (if (not p1)
            (setq p1 (last l))
          )
          ;;last point
          (if (not p2)
            (setq p2 (last lo))
          )
          (setq lo (cons p lo))
          ;;main loutin
          (setq an1 (- (angle p1 p) _pi2)
                an2 (- (angle p p2) _pi2)
          ) ;_(check-pt (list p1 p p2))            
          (setq pt (inters (polar p1 an1 o)
                           (polar p an1 o)
                           (polar p an2 o)
                           (polar p2 an2 o)
                           nil
                  )
          )
          (if pt
            (setq r (cons pt r))
          )
        )
        (if (= gsls_debug 1)
          (draw-pl (list (reverse r) (cons 62 252)))
        ) ;_for test
        (if (> o 0) ;_deal intersectwith itself case
          (progn
            (while r
              (setq p  (car r)
                    p1 (car l)
                    r  (cdr r)
              )
              (if p1
                (progn
                  (setq is nil
                        ip nil
                        lo nil
                  )
                  (while (and r (not is))
                    (setq p2 (car r)
                          p3 (cadr r)
                          r  (cdr r)
                          lo (cons p2 lo)
                    ) ;_if p3 Nil ?
                    (if (and p2 p3 (setq ip (inters p2 p3 p p1 T)))
                      (setq is T)
                    ) ;_(check-pt (list p2 p3 p p1))
                  )
                  (if is
                    (setq l (cons ip l))
                    (setq r (append (reverse lo) r)
                          l (cons p l)
                    )
                  )
                )
                (setq l (cons p l))
              )
            ) ;_Deal out offset OK!
            (if (vl-some (function (lambda (x)
                                     (< (pipl? x l 1e-5) 0)
                                  )
                         )
                         l0
                )
              (setq l nil)
            )
            (setq l (list l))
          )
          (progn ;_Inter offset Will be very Complex ! So be careful .
            (setq l (f1 (reverse r)))
            (if (> (length l) 1)
              (progn
                (setq l
                       (vl-sort
                         (vl-remove-if
                          (function
                             (lambda (x)
                               (or
                                 (vl-some (function (lambda (y)
                                                      (< (pipl? y l0 1e-5) 0)
                                                    )
                                          )
                                          x
                                 )
                                 (vl-some
                                  (function
                                     (lambda (y)
                                       (< (distance y (ClosestPointTo y l0 t))
                                          (- -1e-5 o)
                                       )
                                     )
                                  )
                                  (append x
                                          (mapcar (function (lambda (e1 e2)
                                                               (midpt e1 e2)
                                                            )
                                                  )
                                                  x
                                                  (cdr x)
                                          )
                                  )
                                 )
                               )
                             )
                          )
                          l
                         )
                         (function (lambda (e1 e2)
                                     (> (length e1) (length e2))
                                   )
                         )
                       )
                )
                (setq l
                       (cons
                         (setq l0 (car l))
                         (vl-remove-if-not
                          (function
                             (lambda (x)
                               (vl-some
                                 (function (lambda (y)
                                             (< (pipl? y l0 1e-5) 0)
                                           )
                                 )
                                 x
                               )
                             )
                          )
                          (cdr l)
                         )
                       )
                )
                (f2 l)
              )
              l
            )
          )
        )
      )
    )
  )

  (defun eqmember (p l eps)
    (cond ((not l)  nil)
          ((equal p (car l) eps) l)
          (t (eqmember p (cdr l) eps))
    )
  )

  (defun butlast (a)
    (reverse (cdr (reverse a)))
  )

  (defun ss-pts2area (l)
    (apply (function +)
          (mapcar (function (lambda (x y)
                      (/ (- (* (car x) (cadr y)) (* (car y) (cadr x))) 2.0)
                    )
                  )
                  (cons (last l) l)
                  l
          )
    )
  )

  (defun vec2ang (v1 v2 / ang)
    (if (and v1 (cadr v1) (not (caddr v1)))
      (setq v1 (append v1 (list 0.0)))
    )
    (if (and v2 (cadr v2) (not (caddr v2)))
      (setq v2 (append v2 (list 0.0)))
    ) 
    (angle (list 0 0) (gsls-xy->r v1 (angle (list 0 0) v2)))
  )

  (defun gsls-XY->R (pt ang / an1 dis an2)
    (setq an1 (angle (list 0.0 0.0 0.0) pt)
          dis (distance (list 0.0 0.0 0.0) pt)
          an2 (- an1 ang)
    )
    (list (* dis (cos an2)) (* dis (sin an2)))
  )
  ;;
  ;;;Function : judge a point location with polygon
  ;;;Arg : pt -- a point
  ;;;      pts -- points of polygon
  ;;;      eps -- allowance
  ;;;return :
  ;;;     -1 -- out of polygon , 0 -- at , 1 -- in
  (defun pipl? (pt pts eps / is at a)
    ;; by 狂刀 
    ;; Edit by GSLS(SS) 2011.03.28
    ;; Solved the problem : if a point at the given polygon , it perhap return T or NIL .
    (setq pt (trans pt 0 0) pts (mapcar (function (lambda (x) (trans x 0 0))) pts) Eps (abs Eps))
    (if (vl-some (function (lambda (x) (equal x pt eps))) pts) 
      0
      (progn
        (setq is 
          (equal PI 
                 (abs (apply (function +) 
                   (mapcar (function (lambda (x y / a)
                     (setq a (rem (- (angle pt x) (angle pt y)) PI))
                     (if (equal (+ (distance pt x) (distance pt y)) (distance x y) Eps)
                       (setq at T)
                     )
                     a)
                     );_(check-pt (list x y))
                     (cons (last pts) pts)
                     pts
                   )
                   )
                 ) eps
          )
        )
        (cond 
          (at 0)
          (is 1)
          (T -1)
        )
      )
    )
  )

  (defun ss-assoc (a lst / b res)
    (while (setq b (assoc a lst))
      (setq lst (cdr (member b lst))
            res (cons (cdr b) res)
      )
    )
    (reverse res)
  )

  (defun ClosestPointTo (p l f / k pp d)
    (setq k -1)
    (while f
      (setq pp (nth (setq k (1+ k)) l) d (distance p pp))
      (if (vl-every (function (lambda ( x ) (<= d (distance p x)))) l)
        (setq f nil)
      )
    )
    pp
  )

  (defun pt- (p1 p2)
    (mapcar (function -) p1 p2)
  )

  (defun midpt (p1 p2)
    (mapcar (function (lambda (a b) (/ (+ a b) 2.0))) p1 p2)
  )

  (setq _2pi (* 2.0 pi)
        _pi2 (* 0.5 pi)
  )

  ;; M.R. variant ;;
  (defun lwoffsout (lst dst / ang px1 px2 lstx pp lstt) ;;; lst - point list CCW ;;;
    (mapcar
     '(lambda (p1 p2)
        (if (and p1 p2)
          (progn
            (setq ang (angle p1 p2))
            (setq px1 (polar p1 (- ang (* 0.5 pi)) dst))
            (setq px2 (polar p2 (- ang (* 0.5 pi)) dst))
            (setq lstx (cons (list px1 px2) lstx))
          )
        )
      )
      lst (append (cdr lst) (list (car lst)))
    )
    (mapcar
     '(lambda (a b)
        (setq pp (inters (car a) (cadr a) (car b) (cadr b) nil))
        (setq lstt (cons pp lstt))
      )
      lstx (append (cdr lstx) (list (car lstx)))
    )
    lstt
  )

  (defun draw-pl (lst)
    (entmakex
      (append
        (list (cons 0 "LWPOLYLINE")
          (cons 100  "AcDbEntity")
          (cons 100  "AcDbPolyline")
          (cons 90 (length lst))
        )     
        (mapcar '(lambda (x) (cons 10 x)) lst)
        (list (cons 70 (1+ (* (getvar 'plinegen) 128))))
        (list (list 210 0.0 0.0 1.0))
      )
    )
  )

  (while
    (or
      (not (setq lw (car (entsel "\nPick closed polygonal LWPOLYLINE..."))))
      (and lw
        (/= (cdr (assoc 0 (entget lw))) "LWPOLYLINE")
        (vl-some '(lambda (x) (/= 0.0 x 1e-6)) (mapcar 'cdr (vl-remove-if '(lambda (y) (/= (car y) 42)) (entget lw))))
      )
    )
    (prompt "\nMissed or picked wrong entity type, or picked LWPOLYLINE with some arced segments... Pick again next time...")
  )
  (initget 7)
  (setq dst (getdist "\nPick or specify offset distance : "))
  (vlax-invoke (vlax-ename->vla-object lw) 'offset -1e-3)
  (initget 1 "1 2 3")
  (setq ch (getkword "\nChoose an option [1 chlh_jd/2 MR/3 original] : "))
  (cond
    ( (= ch "1")
      (if (< (vlax-curve-getarea (entlast)) (vlax-curve-getarea lw))
        (setq lwn (draw-pl (car (ss-offsetpts (mapcar 'cdr (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget lw))) dst))))
        (setq lwn (draw-pl (car (ss-offsetpts (reverse (mapcar 'cdr (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget lw)))) dst))))
      )
    )
    ( (= ch "2")
      (if (< (vlax-curve-getarea (entlast)) (vlax-curve-getarea lw))
        (setq lwn (draw-pl (lwoffsout (mapcar 'cdr (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget lw))) dst)))
        (setq lwn (draw-pl (lwoffsout (reverse (mapcar 'cdr (vl-remove-if '(lambda (x) (/= (car x) 10)) (entget lw)))) dst)))
      )
    )
    ( t
      (if (< (vlax-curve-getarea (entlast)) (vlax-curve-getarea lw))
        (progn
          (vlax-invoke (vlax-ename->vla-object lw) 'offset dst)
          (setq lwn (entlast))
        )
        (progn
          (vlax-invoke (vlax-ename->vla-object lw) 'offset (- dst))
          (setq lwn (entlast))
        )
      )
    )
  )
  (entdel (entlast))
  (entdel (entlast))
  (entdel lwn)
  (sssetfirst nil (ssadd lwn))
  (princ)
)